# -*- coding: utf-8 -*-
"""
Created on Fri Mar 11 17:02:45 2016

"""
import Utilities

class CMenu:
    def __init__(self, name, Items=None):
        self.name = name
        self.Items = Items or []

    def AddItem(self, Item):
        self.Items.append(Item)
        if Item.parent != self:
            Item.parent = self
        Item.ID = len(self.Items)

    def RemoveItem(self, Item):
        self.Items.remove(Item)
        if Item.parent == self:
            Item.parent = None

    def Draw(self):
        print ( "")
        print ( "=====================================================================================")
        print ( "Quantifying the uncertainties in modelling the transport of pollutants in rivers")
        print ( "-------------------------------------------------------------------------------------")
        print ( "By Vivian Camacho")
        print ( "=====================================================================================")
        print ( "")
        print(self.name)
        for Item in self.Items:
            Item.draw()
            
    def DrawAndWait(self):
        item = None
        while item == None:
            self.Draw()        
            option = input("Please enter something: ")
            try:
                index = int(option)
            except:
                print ("Invalid input")
                return
                            
            if (index-1<len(self.Items)):
                item = self.Items[index-1]
                item.function()
            else:
                print ("Option does not exist")                    
                
class CItem:
    def __init__(self, name, function, parent=None):
        self.ID = 0
        self.name = name
        self.function = function
        self.parent = parent
        if parent:
            parent.add_Item(self) # use add_Item instead of append, since who
                                  # knows what kind of complex code you'll have
                                  # in add_Item() later on.

    def draw(self):
        # might be more complex later, better use a method.
        print(str(self.ID) + "    " + self.name)